// 处理钻孔数据的子函数，返回格式化后的字符串
function processDrillKey(key, outerArray) {
    var localResult = "";
    // key 形如 "drill12:rule:field2:field3:field4:field5:field6:field7:field8"
    var parts = key.split(":");
    if (parts.length < 9) {
        // 字段不足，直接返回空字符串
        return "";
    }
    
    // 提取各字段
    var ruleType = parts[1],      // 钻孔类型
        field2  = parts[2];       // 刀具编号 部分
        field3  = parts[3];       // 主轴转速 部分		
        field4  = parts[4],       // 用于计算固定循环退刀模式命令组G代码前缀
        field5  = parts[5],       // Z 部分
        field6  = parts[6],       // R 部分
        field7  = parts[7],       // 当 rule 为 1(G82) 时，P 部分
        field8  = parts[8],       // 当 rule 为 2(G83) 时，Q 部分
        field9  = parts[9],       // 当 rule 为 2(G83) 时，K 部分
        field10 = parts[10];      // F 部分	

	if(field2 != 0) {
		localResult += "T" + field2 + "M6" + "\n";
		localResult += "M3S" + field3 + "\n";
	}

    // 计算 G 码前缀：98 + field2
    var gPrefix = 98 + parseFloat(field4);
    
    // 遍历外层和内层数组，每个顶点生成对应的 GCode 字符串
    for (var i = 0; i < outerArray.length; i++) {
        var innerArray = outerArray[i];
        for (var j = 0; j < innerArray.length; j++) {
            var vertex = innerArray[j];
            var vertexStr = "";
            if (ruleType === "0") {
                vertexStr = "G" + gPrefix +
                            "G81" +
                            "X" + vertex.x.toFixed(3) +
                            "Y" + vertex.y.toFixed(3) +
                            "Z" + field5 +
                            "R" + field6 +
                            "F" + field10;
            } else if (ruleType === "1") {
                vertexStr = "G" + gPrefix +
                            "G82" +
                            "X" + vertex.x.toFixed(3) +
                            "Y" + vertex.y.toFixed(3) +
                            "Z" + field5 +
                            "R" + field6 +
                            "P" + field7 +
                            "F" + field10;
            } else if (ruleType === "2") {
                vertexStr = "G" + gPrefix +
                            "G83" +
                            "X" + vertex.x.toFixed(3) +
                            "Y" + vertex.y.toFixed(3) +
                            "Z" + field5 +
                            "R" + field6 +
                            "Q" + field8 +
                            "K" + field9 +
                            "F" + field10;
            }

            localResult += vertexStr + "\n";
        }
    }
    return localResult;
}

// 处理非钻孔数据的子函数，返回格式化后的字符串
function processNonDrillKey(outerArray) {
    var localResult = "";
    for (var i = 0; i < outerArray.length; i++) {
        localResult += "G0Z10\n";
        var innerArray = outerArray[i];
        for (var j = 0; j < innerArray.length; j++) {
            var vertex = innerArray[j];
			vertex.z=vertex.z-90
            var vertexStr = "";
            if (j === 0) {
				if (i === 0) {
					vertexStr = "G0X" + vertex.x.toFixed(3) +
								"Y" + vertex.y.toFixed(3) +
								"C" + vertex.z.toFixed(3) +
								"\nG0Z-10";						
				} else {
					vertexStr = "C" + vertex.z.toFixed(3) +
								"\nG0Z-10" +
								"\nG1X" + vertex.x.toFixed(3) +
								"Y" + vertex.y.toFixed(3) +
								"C" + vertex.z.toFixed(3);								
				}
            } else {
                vertexStr = "G1X" + vertex.x.toFixed(3) +
                            "Y" + vertex.y.toFixed(3) +
                            "C" + vertex.z.toFixed(3);							
            }
            localResult += vertexStr + "\n";
        }
        localResult += "\n";  // 内层数组结束后换行
    }
    return localResult;
}

// 主执行体（IIFE），遍历 dataMap 调用子函数生成最终结果
(function() {
    var result = "";
    if (outputFlag === "GCode") {
        // 不区分大小写匹配 "drill" 开头后跟数字
        var drillPattern = /^drill\d+/i;
        // 匹配以 "drillshape" 开头的 key，不进行内层遍历
        var drillshapePattern = /^drillshape/i;
		
		result += "G43.4\n";
        
        // 遍历 dataMap 对象：每个属性对应一个键
        for (var key in dataMap) {
            if (dataMap.hasOwnProperty(key)) {
                // 如果 key 以 "drillshape" 开头，则跳过处理
                if (drillshapePattern.test(key)) {
                    continue;
                }
                
                var outerArray = dataMap[key];
                if (drillPattern.test(key)) {
                    result += processDrillKey(key, outerArray);
                } else {
                    result += processNonDrillKey(outerArray);
                }
            }
        }
        result += "G0Z10\nG49\nM30\n";
    }
    
    return result;
})();
