(function() {
    /*************************************************************************/
    /*                一、常用字符串处理函数（工具函数）                     */
    /*************************************************************************/

    // 1. 提取 % 后的部分
    function extractAfterPercent(inputString) {
        var percentIndex = inputString.indexOf('%');
        if (percentIndex !== -1) {
            return inputString.substring(percentIndex + 1);
        } else {
            return "";  // 如果没有找到 %，返回空字符串
        }
    }

    // 2. 替换子串
    function replaceString(originalString, toReplace, replaceWith) {
        return originalString.replace(toReplace, replaceWith);
    }

    // 3. 对通过 << 分隔的数字字符串求和
    function sumNumbers(inputString) {
        var numbers = inputString.split('<<');
        var sum = 0;

        for (var i = 0; i < numbers.length; i++) {
            var num = parseFloat(numbers[i]);
            if (!isNaN(num)) {
                sum += num;
            } else {
                return "Invalid number: " + numbers[i];
            }
        }
        return sum;
    }

    // 4. 根据索引提取通过 << 分隔的值
    function extractByIndex(inputString, index) {
        var dataList = inputString.split('<<');
        index = parseInt(index);
        if (index >= 0 && index < dataList.length) {
            return dataList[index];
        } else {
            return "Index out of range";
        }
    }

    // 5. 去掉字符串两端空格
    function trimString(inputString) {
        return inputString.trim();
    }

    // 6. 转换为大写
    function toUpperCaseString(inputString) {
        return inputString.toUpperCase();
    }

    // 7. 转换为小写
    function toLowerCaseString(inputString) {
        return inputString.toLowerCase();
    }

    // 8. 判断是否包含某个子串
    function containsSubstring(inputString, substring) {
        return inputString.indexOf(substring) !== -1;
    }

    // 9. 获取指定子串 (start, length)
    function getSubstring(inputString, start, length) {
        return inputString.substring(start, start + length);
    }

    // 10. 根据分隔符拆分字符串
    function splitString(inputString, delimiter) {
        return inputString.split(delimiter);
    }

    // 11. 替换所有匹配的子串
    function replaceAllString(originalString, toReplace, replaceWith) {
        var regex = new RegExp(toReplace, 'g');
        return originalString.replace(regex, replaceWith);
    }

    // 12. 查找子串位置
    function findIndexOfSubstring(inputString, substring) {
        return inputString.indexOf(substring);
    }

    // 13. 填充字符串（左右对齐）
    function padString(inputString, length, padChar = ' ') {
        // 这里示范同时 padStart 和 padEnd, 具体需求可自行调整
        return inputString.padStart(length, padChar).padEnd(length, padChar);
    }

    // 14. 判断是否以 prefix 开头
    function startsWithString(inputString, prefix) {
        return inputString.startsWith(prefix);
    }

    // 15. 判断是否以 suffix 结尾
    function endsWithString(inputString, suffix) {
        return inputString.endsWith(suffix);
    }

    // 16. 转义字符串中的特殊字符
    function escapeString(inputString) {
        return inputString
            .replace(/\\/g, '\\\\')
            .replace(/"/g, '\\"')
            .replace(/'/g, "\\'");
    }

    // 17. 格式化字符串（{0}, {1}, ...）
    function formatString(template, ...args) {
        return template.replace(/{(\d+)}/g, function(match, number) {
            return typeof args[number] != 'undefined' ? args[number] : match;
        });
    }

    // 18. 反转字符串
    function reverseString(inputString) {
        return inputString.split('').reverse().join('');
    }

    // 19. 统计子串出现次数
    function countOccurrences(inputString, substring) {
        return (inputString.match(new RegExp(substring, 'g')) || []).length;
    }

    // 20. 检查字符串是否为空或仅包含空格
    function isStringEmpty(inputString) {
        return inputString.trim() === "";
    }

    /*************************************************************************/
    /*                二、主函数：processWidget                               */
    /*************************************************************************/

    /**
     * 该函数根据 widgetName, widgetFunc, widgetParam 来调用上述工具函数
     * 你可以根据需求自定义更多逻辑
     */
    function processWidget(widgetName, widgetFunc, widgetParam) {
        // 示例：根据 widgetName 来选择调用对应的字符串处理函数
        if (widgetName === "extractAfterPercent") {
            return extractAfterPercent(widgetParam);

        } else if (widgetName === "replaceString") {
            // widgetParam: 原始字符串<<需要替换的子串<<替换后的子串
            var arr = widgetParam.split('<<');
            if (arr.length >= 3) {
                return replaceString(arr[0], arr[1], arr[2]);
            } else {
                return "replaceString 参数不足";
            }

        } else if (widgetName === "sumNumbers") {
            return sumNumbers(widgetParam);

        } else if (widgetName === "extractByIndex") {
            // widgetFunc 表示要提取的索引
            return extractByIndex(widgetParam, widgetFunc);

        } else if (widgetName === "trimString") {
            return trimString(widgetParam);

        } else if (widgetName === "toUpper") {
            return toUpperCaseString(widgetParam);

        } else if (widgetName === "toLower") {
            return toLowerCaseString(widgetParam);

        } else if (widgetName === "contains") {
            // widgetParam: 字符串<<要查找的子串
            var arr2 = widgetParam.split('<<');
            if (arr2.length >= 2) {
                return containsSubstring(arr2[0], arr2[1]);
            } else {
                return false;
            }

        } else if (widgetName === "getSubstring") {
            // widgetParam: 字符串<<start<<length
            var arr3 = widgetParam.split('<<');
            if (arr3.length >= 3) {
                return getSubstring(arr3[0], parseInt(arr3[1]), parseInt(arr3[2]));
            } else {
                return "getSubstring 参数不足";
            }

        } else if (widgetName === "replaceAllString") {
            // widgetParam: 原始字符串<<要替换的子串<<替换后的子串
            var arr4 = widgetParam.split('<<');
            if (arr4.length >= 3) {
                return replaceAllString(arr4[0], arr4[1], arr4[2]);
            } else {
                return "replaceAllString 参数不足";
            }

        } else if (widgetName === "findIndex") {
            // widgetParam: 字符串<<子串
            var arr5 = widgetParam.split('<<');
            if (arr5.length >= 2) {
                return findIndexOfSubstring(arr5[0], arr5[1]);
            } else {
                return -1;
            }

        } else if (widgetName === "padString") {
            // widgetParam: 字符串<<目标长度<<填充字符
            var arr6 = widgetParam.split('<<');
            if (arr6.length >= 3) {
                return padString(arr6[0], parseInt(arr6[1]), arr6[2]);
            } else {
                return "padString 参数不足";
            }

        } else if (widgetName === "startsWith") {
            // widgetParam: 字符串<<prefix
            var arr7 = widgetParam.split('<<');
            if (arr7.length >= 2) {
                return startsWithString(arr7[0], arr7[1]);
            } else {
                return false;
            }

        } else if (widgetName === "endsWith") {
            // widgetParam: 字符串<<suffix
            var arr8 = widgetParam.split('<<');
            if (arr8.length >= 2) {
                return endsWithString(arr8[0], arr8[1]);
            } else {
                return false;
            }

        } else if (widgetName === "escapeString") {
            return escapeString(widgetParam);

        } else if (widgetName === "formatString") {
            // widgetParam: 模板字符串<<参数1<<参数2<<...
            var arr9 = widgetParam.split('<<');
            var template = arr9[0];
            var args = arr9.slice(1);  // 除第一个外都当做参数
            return formatString(template, ...args);

        } else if (widgetName === "reverseString") {
            return reverseString(widgetParam);

        } else if (widgetName === "countOccurrences") {
            // widgetParam: 字符串<<子串
            var arr10 = widgetParam.split('<<');
			return arr10.length;
			
        } else if (widgetName === "isStringEmpty") {
            return isStringEmpty(widgetParam);

        } else {
            return "No handler for this widget class";
        }
    }

    /*************************************************************************/
    /*                三、脚本执行入口：调用 processWidget                     */
    /*************************************************************************/
    var result = processWidget(widgetName, widgetFunc, widgetParam);
    return result;  // 将结果返回给 C++ 端
})();
